require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../common/common'
require_relative '../../pages/app_options_menu'

describe '[Story# VAR-1750: Appointments Menu and Header Bar]
          [Story# VAR-2339: Update Landing Page and related Menu]' do
  include DriverUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @common = Common.new(@driver)
    @app_menu = AppOptionsMenu.new(@driver)
    APPOINTMENTS = "Appointments/Requests"
  end

  after(:all) do
    @driver.close
  end

  context '[AC#VAR-1806|TC#VAR-1911: Appointments Menu and Header Bar]
           [AC#VAR-2761|TC#VAR-2764: Update Landing Page and related menu criteria]' do
    xit "When an enrolled user views the app landing page, a sub header bar is shown labeled: Appointments" do
      @common.loginEndsOnHome("zztest.patient01", "pass", "D123401")

      @landing.primary_header_element.when_present(TIME_OUT_LIMIT)
      expect(@landing.primary_header).to eq(APPOINTMENTS)
    end

    #No longer valid - App menu is removed
    # it "When a user opens the App Options menu, the first menu option is Appointments. " do
    #   @app_menu.app_menu_element.when_present
    #
    #   @app_menu.app_menu
    #   @app_menu.appointments_element.when_present
    #
    #   expect(@app_menu.getNthOption(1)).to eq(APPOINTMENTS)
    # end
    #
    # it "When a user selects the Appointments app options navigation button, the Appointments enrolled user landing page is displayed with focus on the sub header bar" do
    #   @app_menu.appointments
    #
    #   @landing.primary_header_element.when_present
    #   expect(@landing.primary_header).to eq(APPOINTMENTS)
    #   expect(@landing.primary_header_element).to eq(@landing.element_with_focus)
    # end
  end
end





